#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH=""  # path to cifar10
LORA_PATH=""  # path to the saved checkpoints, e.g., src/diffusion/checkpoint
SYN_PATH=""  # path to save the generated images, e.g., src/diffusion/syn_images

lora_method='gt_dm'
method='SDI2I_LoRA'
img2img_path="runwayml/stable-diffusion-v1-5"

echo "start Generation"

lora_path="${LORA_PATH}/${lora_method}_${exp_id}"
echo "Exp: $exp_id LoRA: $lora_method Method $method"
# Iterate from 0-7, cover all case for nchunks <= 8; otherwise, change --nchunks
for j in {0..7}; do
    CUDA_VISIBLE_DEVICES=$j python src/diffusion/generate.py --index ${j} --method $method --batch_size 24 \
    --use_caption "No" --dataset cifar10 --lora_path $lora_path --if_SDXL "No" --dataset_path $DATA_PATH \
    --img_size 512 --cross_attention_scale 0.5 --image_strength 0.75 --nchunks 8 --syn_path $SYN_PATH \
    --img2img_path $img2img_path --exp_id $exp_id --num_shadow $num_shadow --num_canaries 500 \
    --num_per_image 15 > logs/exp_${exp_id}_gpu_${j}.out 2>&1 &
done
wait
echo "All processes completed"
